package jamezo97.clonecraft.network;

import jamezo97.clonecraft.entity.clone.EntityClone;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class Handler5UpdateOneOption extends Handler{

	@Value(id = 0)
	int cloneID;
	@Value(id = 1)
	int optionID;
	@Value(id = 2)
	boolean optionValue;
	@Value(id = 3)
	int worldID;
	
	public Handler5UpdateOneOption(){
		
	}
	
	public Handler5UpdateOneOption(int cloneID, int optionID, boolean optionValue, int worldID){
		this.cloneID = cloneID;
		this.optionID = optionID;
		this.optionValue = optionValue;
		this.worldID = worldID;
	}
	
	@Override
	public void handle(Side side, INetworkManager manager, EntityPlayer player) {
		if(side == Side.CLIENT){
			updateClient(player, manager);
		}else if(side == Side.SERVER){
			updateServer(player, manager);
		}
	}
	
	public void updateServer(EntityPlayer player, INetworkManager manager){
		World world = MinecraftServer.getServer().worldServerForDimension(worldID);
		if(world != null){
			Entity e = world.getEntityByID(cloneID);
			if(e != null && e instanceof EntityClone){
				if(((EntityClone)e).canUseThisEntity(player.username)){
					((EntityClone)e).options.setOption(optionID, optionValue);
					((EntityClone)e).options.updateOptionToWatchingPlayers(optionID);
				}else if(optionValue != ((EntityClone)e).options.getOption(optionID).value()){
					((EntityClone)e).options.updateOptionTo(optionID, player);
				}
			}
		}
	}
	
	
	@SideOnly(value = Side.CLIENT)
	public void updateClient(EntityPlayer player, INetworkManager manager){
		World world = Minecraft.getMinecraft().theWorld;
		if(world != null){
			Entity e = world.getEntityByID(cloneID);
			if(e != null && e instanceof EntityClone){
				((EntityClone)e).options.setOption(optionID, optionValue);
			}
		}
	}
	
	

}
